const mongoose = require("mongoose");

const infoSchema = new mongoose.Schema(
  {
    phoneNumber: {
      type: String,
      required: [true, "Phone number is required"],
      trim: true,
    },
    email: {
      type: String,
      required: [true, "Email is required"],
      trim: true,
      lowercase: true,
    },
    instagram: {
      type: String,
      required: false,
      trim: true,
    },
    facebook: {
      type: String,
      required: false,
      trim: true,
    },
    twitter: {
      type: String,
      required: false,
      trim: true,
    },
    tiktok: {
      type: String,
      required: false,
      trim: true,
    },
    linkedin: {
      type: String,
      required: false,
      trim: true,
    },
  },
  {
    timestamps: true, // Adds createdAt and updatedAt automatically
  }
);

// Prevent multiple info documents (Optional: keeps data clean)
infoSchema.pre("save", async function (next) {
  const model = this.constructor;
  const count = await model.countDocuments();
  if (count >= 1 && this.isNew) {
    const err = new Error("Only one Info document can exist.");
    next(err);
  } else {
    next();
  }
});

const Info = mongoose.model("Info", infoSchema);

module.exports = Info;
